#source: http://myspworld.wordpress.com/2012/07/13/removing-a-web-part-from-pages-using-powershell/
#This script is to be used after the uninstall on Social Sites

function RemoveNGWebParts([String]$webappurl){

#Add SharePoint Snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue
 
#Write Header to CSV File
"Page URL,  Web Part Name" | out-file NGWebParts.csv
 
#Get all Webs
$webs = Get-SPWebApplication $webappurl | Get-SPSite -Limit All | Get-SPWeb -Limit All
 
#Iterate through webs
foreach ($web in $webs)
{
    #Get All Pages from site's Root into $AllPages Array
    $AllPages = @($web.Files | Where-Object {$_.Name -match ".aspx"})
 
    #Search All Folders for Pages
    foreach ($folder in $web.Folders)
    {
       #Add the pages to $AllPages Array
       $AllPages += @($folder.Files | Where-Object {$_.Name -match ".aspx"})
    }
  
    #Iterate through all pages
    foreach($Page in $AllPages)
    {
        Try{
        $webPartManager = $web.GetLimitedWebPartManager($Page.ServerRelativeUrl, [System.Web.UI.WebControls.WebParts.PersonalizationScope]::Shared)
    
                # Array to Hold Closed Web Parts
                $NGWebParts = @()
                foreach ($webPart in $webPartManager.WebParts | Where-Object {$_ -like "*NewsGator*"})
                {
                 $result = "$($web.site.Url)$($Page.ServerRelativeUrl), $($webpart.Title)"
                 Write-Host "NG Web Part(s) Found at: "$result
                 $result | Out-File NGWebParts.csv -Append
                 $NGWebParts += $webPart
                }
     
                 #Delete NewsGAtor Web Parts
               foreach ($webPart in $NGWebParts)
               {
                   Write-Host "Deleting '$($webPart.Title)' on $($web.site.Url)/$($page.Url)"
                   $webPartManager.DeleteWebPart($webPart)
                }
        }
        Catch [system.exception]
	    {
		write-host "Can't find page at $Page"
		$onError=1
	    }
    
    }
    }
    $web.Dispose()
}