#This script will stop newsgator services on all servers in the farm

function StopNGServices(){

[Array]$serviceNames=@("NewsGator News Stream Service", "NewsGator Social Platform Services v2.", "NewsGator Social Application Services")

Write-Host "Attempting to get SharePoint Servers in Farm" -ForegroundColor White;
$farm = Get-SPFarm;
$servers = $farm.Servers;
Write-Host "Found" $servers.Count "Servers in Farm (including database servers)" -ForegroundColor White;
foreach($server in $servers)
{
	if($serverNames.Role -ne [Microsoft.SharePoint.Administration.SPServerRole]::Invalid)
    {
		foreach($serviceName in $serviceNames)
			{
				$serviceInstance = Get-SPServiceInstance -Server $server | where-object {$_.TypeName -eq $serviceName }
				if($serviceInstance.Status -eq "Online")
            	{
					Write-Host "Attempting to stop" $serviceInstance "on" $server"..." -ForegroundColor White -NoNewline;
   					Write-Host
                try
                	{
        				$serviceinstance | Stop-SPServiceInstance -Confirm:$false
						Write-Host
						Write-Host $serviceInstance "on" $server "is stopped."
						Write-Host
                	}
                catch
                	{
                    	Write-Host "Error Occured: " $_.Message;
                	}
            	}
				else
				{
					Write-Host
    				Write-Host $serviceInstance "on" $server "has already been stopped."
					Write-Host
				}
			}
	}
}
}
