#This script is used to remove NewsGator Solutions

function VerifySolutionUninstall
{ 
	$counter = 1
	$maximum = 20
	$sleeptime = 5
   	while ($Solution.JobExists -and ( $counter -lt $maximum ) ) 
	{
    	Write-Host "Retracting $SolutionName.  Please wait..."
		sleep $sleeptime
		$counter++
	}
}

function Remove-Solution{
param(
[string]$physicalPath,
[string]$name)

$CAUrl = Get-spwebapplication -includecentraladministration | where {$_.DisplayName -eq "SharePoint Central Administration v4"}
$SolutionName = $name
$SolutionPath = Join-Path ($physicalPath) $SolutionName
echo "Extracting $SolutionName from $physicalPath"

#Admin service
$AdminServiceName = "SPAdminV4"
$IsAdminServiceWasRunning = $true;

if ($(Get-Service $AdminServiceName).Status -eq "Stopped")
{
    $IsAdminServiceWasRunning = $false;
    Start-Service $AdminServiceName
    Write-Host 'Service was stopped.  It is now started'
}

#Uninstall the NewsGator Solutions
Write-Host 'Uninstallating Solution' $SolutionName 

$Solution = Get-SPSolution $SolutionName

if($Solution -eq $null)
{
    Write-Host $SolutionName "solution not exist in the farm."
    return;
}

if ($Solution.Deployed -eq $true)
{
    if($Solution.ContainsWebApplicationResource)
    {
        Uninstall-SPSolution $SolutionName -AllWebApplications -Confirm:$false
	#VerifySolutionUninstall
	#Call WaitForTimer function from WaitForTimerScript.ps1
	WaitForTimer($SolutionName)
	Write-Host  $SolutionName " retracted successfully."

    Uninstall-SPSolution $SolutionName -WebApplication $CAUrl -Confirm:$false
	#VerifySolutionUninstall
	#Call WaitForTimer function from WaitForTimerScript.ps1
	WaitForTimer($SolutionName)
	Write-Host  $SolutionName " retracted successfully."
	
    }
    else
    {
        Uninstall-SPSolution $SolutionName -Confirm:$false
	#VerifySolutionUninstall
	#Call WaitForTimer function from WaitForTimerScript.ps1
	WaitForTimer($SolutionName)
	Write-Host  $SolutionName " retracted successfully."
	
    }
}

Write-Host $SolutionName 'has been uninstalled successfully.'
Write-Host

Write-Host 'Removing' $SolutionName

if ($(Get-SPSolution | ? {$_.Name -eq $SolutionName}).Deployed -eq $false)
{
    Remove-SPSolution $SolutionName -Confirm:$false

Write-Host $SolutionName 'has been removed successfully.'
Write-Host
}

if (-not $IsAdminServiceWasRunning)
{
    Stop-Service $AdminServiceName
}
}

function removeNGSolutions(){

cd "..\Solutions Artifacts"
$currentPhysicalPath = Get-Location

#Iterate through all .wsp files in the current Physical Path to deploy solution
get-childitem $currentPhysicalPath -include *.wsp -recurse | foreach ($_) {Remove-Solution $currentPhysicalPath $_.name}

cd "..\scripts"
}