function RecycleServices
{
[Array]$ServiceNames=@("SharePoint Timer Service", "SharePoint 2010 Timer", "IIS Admin Service")

Write-Host "Attempting to get SharePoint Servers in Farm" -ForegroundColor White;
$farm = Get-SPFarm;
[array]$servers= Get-SPServer | ? {$_.Role -eq "Application"};
Write-Host "Found" $servers.Count "Servers in Farm (including database servers)" -ForegroundColor White;
foreach($server in $servers)
{
if($server.Role -ne [Microsoft.SharePoint.Administration.SPServerRole]::Invalid)
{
Write-Host "Attempting to restart services on" $server.Name -ForegroundColor White;
foreach($serviceName in $ServiceNames)
{
$serviceInstance = Get-Service -ComputerName $server.Name -Name $serviceName -ErrorAction SilentlyContinue;
if($serviceInstance -ne $null)
{
Write-Host "Attempting to restart service" $serviceName ".." -ForegroundColor White -NoNewline;
try
{
$restartServiceOutput="";
Restart-Service -InputObject $serviceInstance -force;
Write-Host " Done!" -ForegroundColor Green;
}
catch
{
Write-Host "Error Occured: " $_.Message;
}
}
}
}
}

}