--Reporting

if exists (select * from dbo.sysobjects where id = object_id(N'dbo.UPA_ReportingMigrateUserFromTempUser') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
	drop procedure dbo.UPA_ReportingMigrateUserFromTempUser
GO

CREATE PROCEDURE dbo.UPA_ReportingMigrateUserFromTempUser
(
	@NewUserId bigint,	
	@OldUserId bigint	
)
AS
BEGIN	

	UPDATE dbo.ActivityEventRollup 
	SET UserId = @NewUserId WHERE UserId = @OldUserId

	UPDATE dbo.CommunityScore 
	SET UserId = @NewUserId WHERE UserId = @OldUserId
		
	UPDATE dbo.EventScore 
	SET UserId = @NewUserId WHERE UserId = @OldUserId
	
	IF EXISTS(SELECT 1 FROM dbo.KE_ExcludedUsers WHERE RecordId = @NewUserId)
	BEGIN
		DELETE FROM dbo.KE_ExcludedUsers WHERE RecordId = @OldUserId;
	END
	ELSE
	BEGIN
		UPDATE dbo.KE_ExcludedUsers
		SET RecordId = @NewUserId WHERE RecordId = @OldUserId
	END

	UPDATE dbo.KE_ExcludedTags 
	SET UserId = @NewUserId WHERE UserId = @OldUserId
	
	UPDATE dbo.KE_UserScore
	SET RecordId = @NewUserId WHERE RecordId = @OldUserId
	
	UPDATE dbo.KE_UserSuggestions
	SET RecordId = @NewUserId WHERE RecordId = @OldUserId
		
	UPDATE dbo.SenderScore
	SET UserId = @NewUserId WHERE UserId = @OldUserId

	UPDATE dbo.SenderScore
	SET SenderId = @NewUserId WHERE SenderId = @OldUserId
		
	UPDATE dbo.SubjectScore
	SET UserId = @NewUserId WHERE UserId = @OldUserId
			
	UPDATE dbo.TopNews
	SET UserId=@NewUserId
	FROM dbo.TopNews AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.TopNews AS T2
					WHERE T2.UserId=@NewUserId
					AND T2.EventId=T1.EventId);
	--DELETE FROM dbo.TopNews WHERE UserId=@OldUserId;

	UPDATE dbo.SpotlightUser
	SET RecordId=@NewUserId
	FROM dbo.SpotlightUser AS T1
	WHERE T1.RecordId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.SpotlightUser AS T2
					WHERE T2.RecordId=@NewUserId
					AND T2.AccountName=T1.AccountName);

	--4.5 table
	--UPDATE dbo.ActivityEventImpressions
	--SET UserId=@NewUserId
	--FROM dbo.ActivityEventImpressions AS T1
	--WHERE T1.UserId=@OldUserId
	--AND NOT EXISTS(SELECT 1 FROM dbo.ActivityEventImpressions AS T2
	--				WHERE T2.UserId=@NewUserId
	--				AND T2.HashCode=T1.HashCode);
	--DELETE FROM dbo.ActivityEventImpressions WHERE UserId=@OldUserId;

	UPDATE dbo.ActivityEventViews
	SET UserId=@NewUserId
	FROM dbo.ActivityEventViews AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.ActivityEventViews AS T2
					WHERE T2.UserId=@NewUserId
					AND T2.HashCode=T1.HashCode);
	--DELETE FROM dbo.ActivityEventViews WHERE UserId=@OldUserId;

	UPDATE dbo.ChangeLog 
	SET UserId = @NewUserId
	WHERE UserId = @OldUserId
	--DELETE FROM dbo.ChangeLog WHERE UserId=@OldUserId;

	--4.5 table
	--UPDATE dbo.DailyInfluenceRawScore
	--SET RecordId=@NewUserId
	--FROM dbo.DailyInfluenceRawScore AS T1
	--WHERE T1.RecordId=@OldUserId
	--AND NOT EXISTS(SELECT 1 FROM dbo.DailyInfluenceRawScore AS T2
	--				WHERE T2.RecordId=@NewUserId);
	--DELETE FROM dbo.DailyInfluenceRawScore WHERE RecordId=@OldUserId;

	UPDATE dbo.QA_MetaData
	SET FirstAcceptedAnswerUserId=@NewUserId
	FROM dbo.QA_MetaData AS T1
	WHERE T1.FirstAcceptedAnswerUserId=@OldUserId

	UPDATE dbo.QA_MetaData
	SET FirstAnswerUserId=@NewUserId
	FROM dbo.QA_MetaData AS T1
	WHERE T1.FirstAnswerUserId=@OldUserId

	UPDATE dbo.QA_MetaData
	SET UserId=@NewUserId
	FROM dbo.QA_MetaData AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.QA_MetaData AS T2
					WHERE T2.UserId=@NewUserId
						AND T2.EventId = T1.EventId
						AND T2.HashCode = T1.HashCode
						AND T2.UserId = T1.UserId
						AND T2.CreateDate = T1.CreateDate
						AND T2.GroupId = T1.GroupId);
	--DELETE FROM dbo.QA_MetaData WHERE UserId=@OldUserId;
	
	UPDATE dbo.UserAgentLog
	SET UserId=@NewUserId
	FROM dbo.UserAgentLog AS T1
	WHERE T1.UserId=@OldUserId
	AND NOT EXISTS(SELECT 1 FROM dbo.UserAgentLog AS T2
					WHERE T2.UserId=@NewUserId);
	--DELETE FROM dbo.UserAgentLog WHERE UserId=@OldUserId;
END

GO
